/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateParser {
    public static final SimpleCommandExceptionType f_116741_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType f_116742_ = new DynamicCommandExceptionType(p_116790_ -> new TranslatableComponent("argument.block.id.invalid", p_116790_));
    public static final Dynamic2CommandExceptionType f_116743_ = new Dynamic2CommandExceptionType((p_116820_, p_116821_) -> new TranslatableComponent("argument.block.property.unknown", p_116820_, p_116821_));
    public static final Dynamic2CommandExceptionType f_116744_ = new Dynamic2CommandExceptionType((p_116813_, p_116814_) -> new TranslatableComponent("argument.block.property.duplicate", p_116814_, p_116813_));
    public static final Dynamic3CommandExceptionType f_116745_ = new Dynamic3CommandExceptionType((p_116795_, p_116796_, p_116797_) -> new TranslatableComponent("argument.block.property.invalid", p_116795_, p_116797_, p_116796_));
    public static final Dynamic2CommandExceptionType f_116746_ = new Dynamic2CommandExceptionType((p_116792_, p_116793_) -> new TranslatableComponent("argument.block.property.novalue", p_116792_, p_116793_));
    public static final SimpleCommandExceptionType f_116747_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.block.property.unclosed"));
    private static final char f_174101_ = '[';
    private static final char f_174102_ = '{';
    private static final char f_174103_ = ']';
    private static final char f_174104_ = '=';
    private static final char f_174105_ = ',';
    private static final char f_174106_ = '#';
    private static final BiFunction<SuggestionsBuilder, Registry<Block>, CompletableFuture<Suggestions>> f_116748_ = (p_205646_, p_205647_) -> p_205646_.buildFuture();
    private final StringReader f_116749_;
    private final boolean f_116750_;
    private final Map<Property<?>, Comparable<?>> f_116751_ = Maps.newLinkedHashMap();
    private final Map<String, String> f_116752_ = Maps.newHashMap();
    private ResourceLocation f_116753_ = new ResourceLocation("");
    private StateDefinition<Block, BlockState> f_116754_;
    private BlockState f_116755_;
    @Nullable
    private CompoundTag f_116756_;
    @Nullable
    private TagKey<Block> f_116757_;
    private int f_116758_;
    private BiFunction<SuggestionsBuilder, Registry<Block>, CompletableFuture<Suggestions>> f_116759_ = f_116748_;

    public BlockStateParser(StringReader p_116762_, boolean p_116763_) {
        this.f_116749_ = p_116762_;
        this.f_116750_ = p_116763_;
    }

    public Map<Property<?>, Comparable<?>> m_116764_() {
        return this.f_116751_;
    }

    @Nullable
    public BlockState m_116808_() {
        return this.f_116755_;
    }

    @Nullable
    public CompoundTag m_116815_() {
        return this.f_116756_;
    }

    @Nullable
    public TagKey<Block> m_205617_() {
        return this.f_116757_;
    }

    public BlockStateParser m_116806_(boolean p_116807_) throws CommandSyntaxException {
        this.f_116759_ = this::m_205642_;
        if (this.f_116749_.canRead() && this.f_116749_.peek() == '#') {
            this.m_116830_();
            this.f_116759_ = this::m_205633_;
            if (this.f_116749_.canRead() && this.f_116749_.peek() == '[') {
                this.m_116838_();
                this.f_116759_ = this::m_205624_;
            }
        } else {
            this.m_116826_();
            this.f_116759_ = this::m_205636_;
            if (this.f_116749_.canRead() && this.f_116749_.peek() == '[') {
                this.m_116834_();
                this.f_116759_ = this::m_205624_;
            }
        }
        if (p_116807_ && this.f_116749_.canRead() && this.f_116749_.peek() == '{') {
            this.f_116759_ = f_116748_;
            this.m_116842_();
        }
        return this;
    }

    private CompletableFuture<Suggestions> m_205611_(SuggestionsBuilder p_205612_, Registry<Block> p_205613_) {
        if (p_205612_.getRemaining().isEmpty()) {
            p_205612_.suggest(String.valueOf(']'));
        }
        return this.m_205618_(p_205612_, p_205613_);
    }

    private CompletableFuture<Suggestions> m_205614_(SuggestionsBuilder p_205615_, Registry<Block> p_205616_) {
        if (p_205615_.getRemaining().isEmpty()) {
            p_205615_.suggest(String.valueOf(']'));
        }
        return this.m_205621_(p_205615_, p_205616_);
    }

    private CompletableFuture<Suggestions> m_205618_(SuggestionsBuilder p_205619_, Registry<Block> p_205620_) {
        String s = p_205619_.getRemaining().toLowerCase(Locale.ROOT);
        for (Property property : this.f_116755_.m_61147_()) {
            if (this.f_116751_.containsKey(property) || !property.m_61708_().startsWith(s)) continue;
            p_205619_.suggest(property.m_61708_() + "=");
        }
        return p_205619_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_205621_(SuggestionsBuilder p_205622_, Registry<Block> p_205623_) {
        String s = p_205622_.getRemaining().toLowerCase(Locale.ROOT);
        if (this.f_116757_ != null) {
            for (Holder<Block> holder : p_205623_.m_206058_(this.f_116757_)) {
                for (Property property : holder.m_203334_().m_49965_().m_61092_()) {
                    if (this.f_116752_.containsKey(property.m_61708_()) || !property.m_61708_().startsWith(s)) continue;
                    p_205622_.suggest(property.m_61708_() + "=");
                }
            }
        }
        return p_205622_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_205624_(SuggestionsBuilder p_205625_, Registry<Block> p_205626_) {
        if (p_205625_.getRemaining().isEmpty() && this.m_205605_(p_205626_)) {
            p_205625_.suggest(String.valueOf('{'));
        }
        return p_205625_.buildFuture();
    }

    private boolean m_205605_(Registry<Block> p_205606_) {
        if (this.f_116755_ != null) {
            return this.f_116755_.m_155947_();
        }
        if (this.f_116757_ != null) {
            for (Holder<Block> holder : p_205606_.m_206058_(this.f_116757_)) {
                if (!holder.m_203334_().m_49966_().m_155947_()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> m_205627_(SuggestionsBuilder p_205628_, Registry<Block> p_205629_) {
        if (p_205628_.getRemaining().isEmpty()) {
            p_205628_.suggest(String.valueOf('='));
        }
        return p_205628_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_205630_(SuggestionsBuilder p_205631_, Registry<Block> p_205632_) {
        if (p_205631_.getRemaining().isEmpty()) {
            p_205631_.suggest(String.valueOf(']'));
        }
        if (p_205631_.getRemaining().isEmpty() && this.f_116751_.size() < this.f_116755_.m_61147_().size()) {
            p_205631_.suggest(String.valueOf(','));
        }
        return p_205631_.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder m_116786_(SuggestionsBuilder p_116787_, Property<T> p_116788_) {
        for (Comparable t : p_116788_.m_6908_()) {
            if (t instanceof Integer) {
                p_116787_.suggest(((Integer)t).intValue());
                continue;
            }
            p_116787_.suggest(p_116788_.m_6940_(t));
        }
        return p_116787_;
    }

    private CompletableFuture<Suggestions> m_205597_(SuggestionsBuilder p_205598_, Registry<Block> p_205599_, String p_205600_) {
        boolean flag = false;
        if (this.f_116757_ != null) {
            block0: for (Holder<Block> holder : p_205599_.m_206058_(this.f_116757_)) {
                Block block = holder.m_203334_();
                Property property = block.m_49965_().m_61081_(p_205600_);
                if (property != null) {
                    BlockStateParser.m_116786_(p_205598_, property);
                }
                if (flag) continue;
                for (Property property1 : block.m_49965_().m_61092_()) {
                    if (this.f_116752_.containsKey(property1.m_61708_())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            p_205598_.suggest(String.valueOf(','));
        }
        p_205598_.suggest(String.valueOf(']'));
        return p_205598_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_205633_(SuggestionsBuilder p_205634_, Registry<Block> p_205635_) {
        if (p_205634_.getRemaining().isEmpty() && this.f_116757_ != null) {
            Holder<Block> holder;
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator<Holder<Block>> iterator = p_205635_.m_206058_(this.f_116757_).iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = (holder = iterator.next()).m_203334_()).m_49965_().m_61092_().isEmpty()) && (flag1 |= block.m_49966_().m_155947_()))) {
            }
            if (flag) {
                p_205634_.suggest(String.valueOf('['));
            }
            if (flag1) {
                p_205634_.suggest(String.valueOf('{'));
            }
        }
        return this.m_205639_(p_205634_, p_205635_);
    }

    private CompletableFuture<Suggestions> m_205636_(SuggestionsBuilder p_205637_, Registry<Block> p_205638_) {
        if (p_205637_.getRemaining().isEmpty()) {
            if (!this.f_116755_.m_60734_().m_49965_().m_61092_().isEmpty()) {
                p_205637_.suggest(String.valueOf('['));
            }
            if (this.f_116755_.m_155947_()) {
                p_205637_.suggest(String.valueOf('{'));
            }
        }
        return p_205637_.buildFuture();
    }

    private CompletableFuture<Suggestions> m_205639_(SuggestionsBuilder p_205640_, Registry<Block> p_205641_) {
        return SharedSuggestionProvider.m_82957_(p_205641_.m_203613_().map(TagKey::f_203868_), (SuggestionsBuilder)p_205640_.createOffset(this.f_116758_).add(p_205640_));
    }

    private CompletableFuture<Suggestions> m_205642_(SuggestionsBuilder p_205643_, Registry<Block> p_205644_) {
        if (this.f_116750_) {
            SharedSuggestionProvider.m_205106_(p_205644_.m_203613_().map(TagKey::f_203868_), (SuggestionsBuilder)p_205643_, (String)String.valueOf('#'));
        }
        SharedSuggestionProvider.m_82926_(p_205644_.m_6566_(), (SuggestionsBuilder)p_205643_);
        return p_205643_.buildFuture();
    }

    public void m_116826_() throws CommandSyntaxException {
        int i = this.f_116749_.getCursor();
        this.f_116753_ = ResourceLocation.m_135818_(this.f_116749_);
        Block block = (Block)((Object)Registry.f_122824_.m_6612_(this.f_116753_).orElseThrow(() -> {
            this.f_116749_.setCursor(i);
            return f_116742_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString());
        }));
        this.f_116754_ = block.m_49965_();
        this.f_116755_ = block.m_49966_();
    }

    public void m_116830_() throws CommandSyntaxException {
        if (!this.f_116750_) {
            throw f_116741_.create();
        }
        this.f_116759_ = this::m_205639_;
        this.f_116749_.expect('#');
        this.f_116758_ = this.f_116749_.getCursor();
        this.f_116757_ = TagKey.m_203882_(Registry.f_122901_, (ResourceLocation)ResourceLocation.m_135818_(this.f_116749_));
    }

    public void m_116834_() throws CommandSyntaxException {
        this.f_116749_.skip();
        this.f_116759_ = this::m_205611_;
        this.f_116749_.skipWhitespace();
        while (this.f_116749_.canRead() && this.f_116749_.peek() != ']') {
            this.f_116749_.skipWhitespace();
            int i = this.f_116749_.getCursor();
            String s = this.f_116749_.readString();
            Property property = this.f_116754_.m_61081_(s);
            if (property == null) {
                this.f_116749_.setCursor(i);
                throw f_116743_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)s);
            }
            if (this.f_116751_.containsKey(property)) {
                this.f_116749_.setCursor(i);
                throw f_116744_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)s);
            }
            this.f_116749_.skipWhitespace();
            this.f_116759_ = this::m_205627_;
            if (!this.f_116749_.canRead() || this.f_116749_.peek() != '=') {
                throw f_116746_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)s);
            }
            this.f_116749_.skip();
            this.f_116749_.skipWhitespace();
            this.f_116759_ = (p_205603_, p_205604_) -> BlockStateParser.m_116786_(p_205603_, property).buildFuture();
            int j = this.f_116749_.getCursor();
            this.m_116775_(property, this.f_116749_.readString(), j);
            this.f_116759_ = this::m_205630_;
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead()) continue;
            if (this.f_116749_.peek() == ',') {
                this.f_116749_.skip();
                this.f_116759_ = this::m_205618_;
                continue;
            }
            if (this.f_116749_.peek() == ']') break;
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        if (this.f_116749_.canRead()) {
            this.f_116749_.skip();
            return;
        }
        throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
    }

    public void m_116838_() throws CommandSyntaxException {
        this.f_116749_.skip();
        this.f_116759_ = this::m_205614_;
        int i = -1;
        this.f_116749_.skipWhitespace();
        while (this.f_116749_.canRead() && this.f_116749_.peek() != ']') {
            this.f_116749_.skipWhitespace();
            int j = this.f_116749_.getCursor();
            String s = this.f_116749_.readString();
            if (this.f_116752_.containsKey(s)) {
                this.f_116749_.setCursor(j);
                throw f_116744_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)s);
            }
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead() || this.f_116749_.peek() != '=') {
                this.f_116749_.setCursor(j);
                throw f_116746_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)s);
            }
            this.f_116749_.skip();
            this.f_116749_.skipWhitespace();
            this.f_116759_ = (p_205609_, p_205610_) -> this.m_205597_((SuggestionsBuilder)p_205609_, (Registry<Block>)p_205610_, s);
            i = this.f_116749_.getCursor();
            String s1 = this.f_116749_.readString();
            this.f_116752_.put(s, s1);
            this.f_116749_.skipWhitespace();
            if (!this.f_116749_.canRead()) continue;
            i = -1;
            if (this.f_116749_.peek() == ',') {
                this.f_116749_.skip();
                this.f_116759_ = this::m_205621_;
                continue;
            }
            if (this.f_116749_.peek() == ']') break;
            throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
        }
        if (this.f_116749_.canRead()) {
            this.f_116749_.skip();
            return;
        }
        if (i >= 0) {
            this.f_116749_.setCursor(i);
        }
        throw f_116747_.createWithContext((ImmutableStringReader)this.f_116749_);
    }

    public void m_116842_() throws CommandSyntaxException {
        this.f_116756_ = new TagParser(this.f_116749_).m_129373_();
    }

    private <T extends Comparable<T>> void m_116775_(Property<T> p_116776_, String p_116777_, int p_116778_) throws CommandSyntaxException {
        Optional optional = p_116776_.m_6215_(p_116777_);
        if (!optional.isPresent()) {
            this.f_116749_.setCursor(p_116778_);
            throw f_116745_.createWithContext((ImmutableStringReader)this.f_116749_, (Object)this.f_116753_.toString(), (Object)p_116776_.m_61708_(), (Object)p_116777_);
        }
        this.f_116755_ = (BlockState)((Object)this.f_116755_.m_61124_(p_116776_, (Comparable)optional.get()));
        this.f_116751_.put(p_116776_, (Comparable)optional.get());
    }

    public static String m_116769_(BlockState p_116770_) {
        StringBuilder stringbuilder = new StringBuilder(Registry.f_122824_.m_7981_((Object)p_116770_.m_60734_()).toString());
        if (!p_116770_.m_61147_().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry entry : p_116770_.m_61148_().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                BlockStateParser.m_116802_(stringbuilder, (Property)entry.getKey(), (Comparable)entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void m_116802_(StringBuilder p_116803_, Property<T> p_116804_, Comparable<?> p_116805_) {
        p_116803_.append(p_116804_.m_61708_());
        p_116803_.append('=');
        p_116803_.append(p_116804_.m_6940_(p_116805_));
    }

    public CompletableFuture<Suggestions> m_205594_(SuggestionsBuilder p_205595_, Registry<Block> p_205596_) {
        return this.f_116759_.apply(p_205595_.createOffset(this.f_116749_.getCursor()), p_205596_);
    }

    public Map<String, String> m_116846_() {
        return this.f_116752_;
    }
}

